from models.resnet import ResNet43_8s
from models.clip_wo_skip import CLIPWithoutSkipConnections

from models.rn50_bert_unet import RN50BertUNet
from models.rn50_bert_lingunet import RN50BertLingUNet
from models.rn50_bert_lingunet_lat import RN50BertLingUNetLat
from models.untrained_rn50_bert_lingunet import UntrainedRN50BertLingUNet

from models.clip_unet import CLIPUNet
from models.clip_lingunet import CLIPLingUNet

from models.resnet_lang import ResNet43_8s_lang

from models.resnet_lat import ResNet45_10s
from models.clip_unet_lat import CLIPUNetLat
from models.clip_lingunet_lat import CLIPLingUNetLat
from models.clip_film_lingunet_lat import CLIPFilmLingUNet


names = {
    # resnet
    'plain_resnet': ResNet43_8s,
    'plain_resnet_lang': ResNet43_8s_lang,

    # without skip-connections
    'clip_woskip': CLIPWithoutSkipConnections,

    # unet
    'clip_unet': CLIPUNet,
    'rn50_bert_unet': RN50BertUNet,

    # lingunet
    'clip_lingunet': CLIPLingUNet,
    'rn50_bert_lingunet': RN50BertLingUNet,
    'untrained_rn50_bert_lingunet': UntrainedRN50BertLingUNet,

    # lateral connections
    'plain_resnet_lat': ResNet45_10s,
    'clip_unet_lat': CLIPUNetLat,
    'clip_lingunet_lat': CLIPLingUNetLat,
    'clip_film_lingunet_lat': CLIPFilmLingUNet,
    'rn50_bert_lingunet_lat': RN50BertLingUNetLat,
}
